<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Contact extends Model 
{

    protected $table = 'contacts';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'subject', 'message', 'type', 'contactable_id', 'rememberToken');

    public function client()
    {
        return $this->morphMany('App\Model\Client');
    }

    public function restaurant()
    {
        return $this->morphMany('App\Model\Restaurant');
    }

}